IF OBJECT_ID('UFD_BUSCA_CONTA_MOV') IS NOT NULL
	BEGIN
		DROP FUNCTION UFD_BUSCA_CONTA_MOV
	END
	
GO	

SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
GO
--select * from UFD_BUSCA_CONTA_MOV (1,175,5,0,28)
CREATE   FUNCTION [dbo].[UFD_BUSCA_CONTA_MOV](	    	@CD_EMP 		INT,
														@CD_MOV_OP 		INT,
														@TP_CONTA		INT,
														@TP_TRANSA		INT,
														@CD_FILIAL		INT)
RETURNS @RS_RETURN TABLE(
		CD_FILIAL					INT, 
		CD_MOV_OP					INT, 
		DS_MOV_OP_CONTABIL			VARCHAR(100),
		CNT_CENTRO_CUSTO			INT,
		DS_CENTRO_CUSTO				VARCHAR(100),
		FLAG_APLICAR_CENTRO_CUSTO 	INT,
		CD_CTB_CNT					VARCHAR(100),
		CD_CTB_CNT_RED				INT,
		FLAG_NAO_GERAR_NA_EXPORTACAO_CONTABIL	INT)

		
	BEGIN
		DECLARE @RS_CD_CTB_CNT_DEB 						VARCHAR(100)
		DECLARE @RS_CD_CTB_CNT_RED_DEB					INT
		DECLARE @RS_CD_CTB_CNT_CRED						VARCHAR(100)
		DECLARE @RS_CD_CTB_CNT_RED_CRED					INT
		DECLARE @RS_DS_MOV_OP_CONTABIL 					VARCHAR(100)
		DECLARE @RS_FLAG_USAR_CENTRO_CUSTO_FILIAL		INT
		DECLARE @RS_FLAG_APLICAR_CENTRO_CUSTO_CREDITO	INT
		DECLARE @RS_FLAG_APLICAR_CENTRO_CUSTO_DEBITO 	INT
		DECLARE @RS_FLAG_NAO_GERAR_NA_EXPORTACAO_CONTABIL 	INT

		DECLARE @RET_CD_FILIAL					INT
		DECLARE @RET_CD_MOV_OP					INT 
		DECLARE @RET_DS_MOV_OP_CONTABIL			VARCHAR(100)
		DECLARE @RET_CNT_CENTRO_CUSTO			INT
		DECLARE @RET_DS_CENTRO_CUSTO			VARCHAR(100)
		DECLARE @RET_FLAG_APLICAR_CENTRO_CUSTO 	INT
		DECLARE @RET_CD_CTB_CNT					VARCHAR(100)
		DECLARE @RET_CD_CTB_CNT_RED				INT
		
		DECLARE @RSMOVCTB TABLE (CD_CTB_CNT_DEB VARCHAR(100), 
						   CD_CTB_CNT_RED_DEB INT, 
						   CD_CTB_CNT_CRED VARCHAR(100), 
						   CD_CTB_CNT_RED_CRED INT, 
						   DS_MOV_OP_CONTABIL VARCHAR(100), 
						   FLAG_USAR_CENTRO_CUSTO_FILIAL INT, 
						   FLAG_APLICAR_CENTRO_CUSTO_CREDITO INT,
				           FLAG_APLICAR_CENTRO_CUSTO_DEBITO INT,
						   FLAG_NAO_GERAR_NA_EXPORTACAO_CONTABIL INT)

		INSERT INTO @RSMOVCTB
					(CD_CTB_CNT_DEB, 
					CD_CTB_CNT_RED_DEB, 
					CD_CTB_CNT_CRED, 
					CD_CTB_CNT_RED_CRED, 
					DS_MOV_OP_CONTABIL, 
					FLAG_USAR_CENTRO_CUSTO_FILIAL, 
					FLAG_APLICAR_CENTRO_CUSTO_CREDITO,
				    FLAG_APLICAR_CENTRO_CUSTO_DEBITO,
					FLAG_NAO_GERAR_NA_EXPORTACAO_CONTABIL)
			SELECT 
				TOP 1
				CD_CTB_CNT_DEB, 
				CD_CTB_CNT_RED_DEB, 
				CD_CTB_CNT_CRED, 
				CD_CTB_CNT_RED_CRED, 
				DS_MOV_OP_CONTABIL, 
				ISNULL(FLAG_USAR_CENTRO_CUSTO_FILIAL,0) AS FLAG_USAR_CENTRO_CUSTO_FILIAL, 
				ISNULL(FLAG_APLICAR_CENTRO_CUSTO_CREDITO,0) AS FLAG_APLICAR_CENTRO_CUSTO_CREDITO,
				ISNULL(FLAG_APLICAR_CENTRO_CUSTO_DEBITO,0) AS FLAG_APLICAR_CENTRO_CUSTO_DEBITO,
				ISNULL(FLAG_NAO_GERAR_NA_EXPORTACAO_CONTABIL,0) AS FLAG_NAO_GERAR_NA_EXPORTACAO_CONTABIL  				
			FROM 
				GLB_MOV_OP_CNT_CTB
			WHERE 
				CD_MOV_OP 		= @CD_MOV_OP
				AND TIPO_CONTA 	= @TP_CONTA

IF NOT EXISTS(SELECT
				TOP 1 CD_CTB_CNT_DEB
			  FROM
				@RSMOVCTB)
BEGIN
		INSERT INTO @RSMOVCTB
					(CD_CTB_CNT_DEB, 
					CD_CTB_CNT_RED_DEB, 
					CD_CTB_CNT_CRED, 
					CD_CTB_CNT_RED_CRED, 
					DS_MOV_OP_CONTABIL, 
					FLAG_USAR_CENTRO_CUSTO_FILIAL, 
					FLAG_APLICAR_CENTRO_CUSTO_CREDITO,
				    FLAG_APLICAR_CENTRO_CUSTO_DEBITO,
					FLAG_NAO_GERAR_NA_EXPORTACAO_CONTABIL)
			SELECT 
				'' AS CD_CTB_CNT_DEB, 
				0 AS CD_CTB_CNT_RED_DEB, 
				'' AS CD_CTB_CNT_CRED, 
				0 AS CD_CTB_CNT_RED_CRED, 
				'' AS DS_MOV_OP_CONTABIL, 
				0 AS FLAG_USAR_CENTRO_CUSTO_FILIAL, 
				0 AS FLAG_APLICAR_CENTRO_CUSTO_CREDITO,
				0 AS FLAG_APLICAR_CENTRO_CUSTO_DEBITO,
				0 AS FLAG_NAO_GERAR_NA_EXPORTACAO_CONTABIL
END


		DECLARE RS_RESULT
		CURSOR FOR
		SELECT
			CD_CTB_CNT_DEB, 
			CD_CTB_CNT_RED_DEB, 
			CD_CTB_CNT_CRED, 
			CD_CTB_CNT_RED_CRED, 
			DS_MOV_OP_CONTABIL, 
			FLAG_USAR_CENTRO_CUSTO_FILIAL, 
			FLAG_APLICAR_CENTRO_CUSTO_CREDITO,
			FLAG_APLICAR_CENTRO_CUSTO_DEBITO,
			FLAG_NAO_GERAR_NA_EXPORTACAO_CONTABIL
		FROM
			@RSMOVCTB


		--Abrindo cursor
		OPEN RS_RESULT
		
		--Atribuindo valores do select nas variveis
		FETCH NEXT FROM RS_RESULT INTO 
			@RS_CD_CTB_CNT_DEB 						,
			@RS_CD_CTB_CNT_RED_DEB					,
			@RS_CD_CTB_CNT_CRED						,
			@RS_CD_CTB_CNT_RED_CRED					,
			@RS_DS_MOV_OP_CONTABIL 					,
			@RS_FLAG_USAR_CENTRO_CUSTO_FILIAL		,
			@RS_FLAG_APLICAR_CENTRO_CUSTO_CREDITO	,
			@RS_FLAG_APLICAR_CENTRO_CUSTO_DEBITO	,
			@RS_FLAG_NAO_GERAR_NA_EXPORTACAO_CONTABIL			
			
		--Iniciando lao
		WHILE @@FETCH_STATUS = 0
			BEGIN
									
				SET @RET_DS_MOV_OP_CONTABIL 		= @RS_DS_MOV_OP_CONTABIL
				SET @RET_FLAG_APLICAR_CENTRO_CUSTO 	= 0            
				
	            If @RS_FLAG_USAR_CENTRO_CUSTO_FILIAL = 1 
					BEGIN 
						IF @TP_TRANSA = 0
							BEGIN
								IF @RS_FLAG_APLICAR_CENTRO_CUSTO_CREDITO = 1
									BEGIN
										SET @RET_FLAG_APLICAR_CENTRO_CUSTO 	= 1
										
										--RETIRAR ESTA INSTRUCAO ABAIXO DE DENTRO DO LOOP....
										SET @RET_CNT_CENTRO_CUSTO = ISNULL((SELECT DBO.UFD_BUSCA_PARAM_SISTEMA(@CD_EMP, 'COD_CENTRO_CUSTO_FILIAL', 1, @CD_FILIAL)), 0)
										
										IF @RET_CNT_CENTRO_CUSTO = 0
											BEGIN
												SET @RET_DS_CENTRO_CUSTO = 'Nao definido parametro por filial => COD_CENTRO_CUSTO_FILIAL' 
											END
									END
							END
						ELSE
							BEGIN
								IF @RS_FLAG_APLICAR_CENTRO_CUSTO_DEBITO = 1
									BEGIN
										SET @RET_FLAG_APLICAR_CENTRO_CUSTO 	= 1
										--RETIRAR ESTA INSTRUCAO ABAIXO DE DENTRO DO LOOP....
										SET @RET_CNT_CENTRO_CUSTO = ISNULL((SELECT DBO.UFD_BUSCA_PARAM_SISTEMA(@CD_EMP, 'COD_CENTRO_CUSTO_FILIAL', 1, @CD_FILIAL)), 0)
										
										IF @RET_CNT_CENTRO_CUSTO = 0
											BEGIN
												SET @RET_DS_CENTRO_CUSTO = 'Nao definido parametro por filial => COD_CENTRO_CUSTO_FILIAL' 
											END									
									END
							END
						
					
						IF @RET_CNT_CENTRO_CUSTO > 0
							BEGIN
								SELECT 
									@RET_DS_CENTRO_CUSTO 	= DS_CENTRO_CTB,
									@RET_CNT_CENTRO_CUSTO 	= CNT_CENTRO_CTB
								FROM
								    CTB_CENTRO_CUSTO
								WHERE
								    CD_EMP = @CD_EMP
								    AND CD_CENTRO_CTB = @RET_CNT_CENTRO_CUSTO
							END					
					END 

				IF @TP_TRANSA = 0
					BEGIN 				
						SET @RET_CD_CTB_CNT 		= @RS_CD_CTB_CNT_CRED
						SET @RET_CD_CTB_CNT_RED 	= @RS_CD_CTB_CNT_RED_CRED
					END
				ELSE
					BEGIN
						SET @RET_CD_CTB_CNT 		= @RS_CD_CTB_CNT_DEB
						SET @RET_CD_CTB_CNT_RED 	= @RS_CD_CTB_CNT_RED_DEB
					END
				
				
				IF @RET_CD_CTB_CNT_RED = 0 AND @RET_CD_CTB_CNT = '' 
					BEGIN
						SET @RET_CD_CTB_CNT 		= 'Nat.movimentao: ' + CAST(@CD_MOV_OP AS VARCHAR) + ', Sem classificao. '
						SET @RET_DS_MOV_OP_CONTABIL = 'Nat.movimentao: ' + CAST(@CD_MOV_OP AS VARCHAR) + ', Sem classificao. '					
					END

				
				INSERT INTO @RS_RETURN
				SELECT
					@CD_FILIAL,
					@CD_MOV_OP,
					@RET_DS_MOV_OP_CONTABIL,
					ISNULL(@RET_CNT_CENTRO_CUSTO,0),
					ISNULL(@RET_DS_CENTRO_CUSTO,''),
					@RET_FLAG_APLICAR_CENTRO_CUSTO,
					@RET_CD_CTB_CNT,
					@RET_CD_CTB_CNT_RED,
					@RS_FLAG_NAO_GERAR_NA_EXPORTACAO_CONTABIL
				
				--Atribuindo valores do select nas variveis
				FETCH NEXT FROM RS_RESULT INTO 
					@RS_CD_CTB_CNT_DEB 						,
					@RS_CD_CTB_CNT_RED_DEB					,
					@RS_CD_CTB_CNT_CRED						,
					@RS_CD_CTB_CNT_RED_CRED					,
					@RS_DS_MOV_OP_CONTABIL 					,
					@RS_FLAG_USAR_CENTRO_CUSTO_FILIAL		,
					@RS_FLAG_APLICAR_CENTRO_CUSTO_CREDITO	,
					@RS_FLAG_APLICAR_CENTRO_CUSTO_DEBITO 	,
					@RS_FLAG_NAO_GERAR_NA_EXPORTACAO_CONTABIL
					
			END			
		
		CLOSE RS_RESULT
		DEALLOCATE RS_RESULT	
		
		RETURN
		
	END
 


